<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class Training extends Model 
{

    protected $table = 'trainings';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];
    protected $fillable = array('place_id', 'type_id', 'day', 'startHour', 'endHour', 'content');

    public function places()
    {
        return $this->belongsTo('App\Models\Place');
    }

    public function trainers()
    {
        return $this->belongsTo('App\Models\Trainer');
    }

    public function types()
    {
        return $this->belongsTo('App\Models\Type');
    }

    public function athletes()
    {
        return $this->belongsToMany('App\Models\Athlete');
    }

}